/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.view;

import android.graphics.Rect;
import android.os.Build;
import android.view.Gravity;
import androidx.core.view.GravityCompatJellybeanMr1;

public class GravityCompat {
    static final GravityCompatImpl IMPL;
    public static final int RELATIVE_LAYOUT_DIRECTION = 0x800000;
    public static final int START = 0x800003;
    public static final int END = 0x800005;
    public static final int RELATIVE_HORIZONTAL_GRAVITY_MASK = 0x800007;

    public static void apply(int gravity, int w, int h, Rect container, Rect outRect, int layoutDirection) {
        IMPL.apply(gravity, w, h, container, outRect, layoutDirection);
    }

    public static void apply(int gravity, int w, int h, Rect container, int xAdj, int yAdj, Rect outRect, int layoutDirection) {
        IMPL.apply(gravity, w, h, container, xAdj, yAdj, outRect, layoutDirection);
    }

    public static void applyDisplay(int gravity, Rect display, Rect inoutObj, int layoutDirection) {
        IMPL.applyDisplay(gravity, display, inoutObj, layoutDirection);
    }

    public static int getAbsoluteGravity(int gravity, int layoutDirection) {
        return IMPL.getAbsoluteGravity(gravity, layoutDirection);
    }

    static {
        int version = Build.VERSION.SDK_INT;
        IMPL = version >= 17 ? new GravityCompatImplJellybeanMr1() : new GravityCompatImplBase();
    }

    static class GravityCompatImplJellybeanMr1
    implements GravityCompatImpl {
        GravityCompatImplJellybeanMr1() {
        }

        public int getAbsoluteGravity(int gravity, int layoutDirection) {
            return GravityCompatJellybeanMr1.getAbsoluteGravity(gravity, layoutDirection);
        }

        public void apply(int gravity, int w, int h, Rect container, Rect outRect, int layoutDirection) {
            GravityCompatJellybeanMr1.apply(gravity, w, h, container, outRect, layoutDirection);
        }

        public void apply(int gravity, int w, int h, Rect container, int xAdj, int yAdj, Rect outRect, int layoutDirection) {
            GravityCompatJellybeanMr1.apply(gravity, w, h, container, xAdj, yAdj, outRect, layoutDirection);
        }

        public void applyDisplay(int gravity, Rect display, Rect inoutObj, int layoutDirection) {
            GravityCompatJellybeanMr1.applyDisplay(gravity, display, inoutObj, layoutDirection);
        }
    }

    static class GravityCompatImplBase
    implements GravityCompatImpl {
        GravityCompatImplBase() {
        }

        public int getAbsoluteGravity(int gravity, int layoutDirection) {
            return gravity & 0xFF7FFFFF;
        }

        public void apply(int gravity, int w, int h, Rect container, Rect outRect, int layoutDirection) {
            Gravity.apply((int)gravity, (int)w, (int)h, (Rect)container, (Rect)outRect);
        }

        public void apply(int gravity, int w, int h, Rect container, int xAdj, int yAdj, Rect outRect, int layoutDirection) {
            Gravity.apply((int)gravity, (int)w, (int)h, (Rect)container, (int)xAdj, (int)yAdj, (Rect)outRect);
        }

        public void applyDisplay(int gravity, Rect display, Rect inoutObj, int layoutDirection) {
            Gravity.applyDisplay((int)gravity, (Rect)display, (Rect)inoutObj);
        }
    }

    static interface GravityCompatImpl {
        public int getAbsoluteGravity(int var1, int var2);

        public void apply(int var1, int var2, int var3, Rect var4, Rect var5, int var6);

        public void apply(int var1, int var2, int var3, Rect var4, int var5, int var6, Rect var7, int var8);

        public void applyDisplay(int var1, Rect var2, Rect var3, int var4);
    }
}

