/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.util;

import android.util.Log;
import java.io.Writer;

public class LogWriter
extends Writer {
    private final String mTag;
    private StringBuilder mBuilder = new StringBuilder(128);

    public LogWriter(String tag) {
        this.mTag = tag;
    }

    public void close() {
        this.flushBuilder();
    }

    public void flush() {
        this.flushBuilder();
    }

    public void write(char[] buf, int offset, int count) {
        for (int i = 0; i < count; ++i) {
            char c = buf[offset + i];
            if (c == '\n') {
                this.flushBuilder();
                continue;
            }
            this.mBuilder.append(c);
        }
    }

    private void flushBuilder() {
        if (this.mBuilder.length() > 0) {
            Log.d((String)this.mTag, (String)this.mBuilder.toString());
            this.mBuilder.delete(0, this.mBuilder.length());
        }
    }
}

