/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.os;

import android.os.Build;
import android.os.Environment;
import android.util.Log;
import androidx.core.os.EnvironmentCompatKitKat;
import java.io.File;
import java.io.IOException;

public class EnvironmentCompat {
    private static final String TAG = "EnvironmentCompat";
    public static final String MEDIA_UNKNOWN = "unknown";

    public static String getStorageState(File path) {
        int version = Build.VERSION.SDK_INT;
        if (version >= 19) {
            return EnvironmentCompatKitKat.getStorageState(path);
        }
        try {
            String canonicalPath = path.getCanonicalPath();
            String canonicalExternal = Environment.getExternalStorageDirectory().getCanonicalPath();
            if (canonicalPath.startsWith(canonicalExternal)) {
                return Environment.getExternalStorageState();
            }
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)("Failed to resolve canonical path: " + e));
        }
        return MEDIA_UNKNOWN;
    }
}

