/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.app;

import android.app.Notification;
import android.app.Service;
import android.content.Intent;
import android.os.Build;
import android.os.IBinder;
import android.os.RemoteException;
import androidx.core.app.INotificationSideChannel;

public abstract class NotificationCompatSideChannelService
extends Service {
    private static final int BUILD_VERSION_CODE_KITKAT_WATCH = 20;

    public IBinder onBind(Intent intent) {
        if (intent.getAction().equals("android.support.BIND_NOTIFICATION_SIDE_CHANNEL")) {
            if (Build.VERSION.SDK_INT >= 20) {
                return null;
            }
            return new NotificationSideChannelStub();
        }
        return null;
    }

    public abstract void notify(String var1, int var2, String var3, Notification var4);

    public abstract void cancel(String var1, int var2, String var3);

    public abstract void cancelAll(String var1);

    private void checkPermission(int callingUid, String packageName) {
        for (String validPackage : this.getPackageManager().getPackagesForUid(callingUid)) {
            if (!validPackage.equals(packageName)) continue;
            return;
        }
        throw new SecurityException("NotificationSideChannelService: Uid " + callingUid + " is not authorized for package " + packageName);
    }

    private class NotificationSideChannelStub
    extends INotificationSideChannel.Stub {
        private NotificationSideChannelStub() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notify(String packageName, int id, String tag, Notification notification) throws RemoteException {
            NotificationCompatSideChannelService.this.checkPermission(NotificationSideChannelStub.getCallingUid(), packageName);
            long idToken = NotificationSideChannelStub.clearCallingIdentity();
            try {
                NotificationCompatSideChannelService.this.notify(packageName, id, tag, notification);
            }
            finally {
                NotificationSideChannelStub.restoreCallingIdentity((long)idToken);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel(String packageName, int id, String tag) throws RemoteException {
            NotificationCompatSideChannelService.this.checkPermission(NotificationSideChannelStub.getCallingUid(), packageName);
            long idToken = NotificationSideChannelStub.clearCallingIdentity();
            try {
                NotificationCompatSideChannelService.this.cancel(packageName, id, tag);
            }
            finally {
                NotificationSideChannelStub.restoreCallingIdentity((long)idToken);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelAll(String packageName) {
            NotificationCompatSideChannelService.this.checkPermission(NotificationSideChannelStub.getCallingUid(), packageName);
            long idToken = NotificationSideChannelStub.clearCallingIdentity();
            try {
                NotificationCompatSideChannelService.this.cancelAll(packageName);
            }
            finally {
                NotificationSideChannelStub.restoreCallingIdentity((long)idToken);
            }
        }
    }
}

