function jsonToCommand(j) {
    var json = JSON.parse(j)
    var command = ""
    if (json.videoList) {
        json.videoList.forEach(element => {
            command = command + " -i " + element.filePath
        });
    }

    //dummy audio for those videos who does not have audio channel
    command = command + " -f lavfi -t 1 -i anullsrc=channel_layout=stereo:sample_rate=44100"

    if (json.audioList) {
        json.audioList.forEach(element => {
            command = command + " -i " + element.filePath
        });
    }

    if (json.bgm) {
        command = command + " -stream_loop -1 -i " + json.bgm.filePath
    }

    if (json.pip) {
        command = command + " -i " + json.pip.filePath
    }

    if (json.imageList) {
        json.imageList.forEach(element => {
            command = command + " -i " + element.filePath
        });
    }

    command = command + " -filter_complex "
    var resourcePivot = 0
    var audioStreams = 0
    //trim + scale videos first
    for (var index = 0; index < json.videoList.length; index++) {
        var video = json.videoList[index]
        if (video.start != -1 && video.end != -1) {
            //need trim
            //trim video first
            command = command + "[" + index + ":v]trim=start=" + video.start + "ms:end=" + video.end + "ms,setpts=PTS-STARTPTS,fps=24,format=yuv420p[v" + index + "];"
            //trim audio then, only if has audio stream
            if (video.a_streams > 0) {
                command = command + "[" + index + ":a]atrim=start=" + video.start + "ms:end=" + video.end + "ms,asetpts=PTS-STARTPTS[a" + audioStreams + "];"
                audioStreams = audioStreams + 1
            }
            //scale video at last
            command = command + "[v" + index + "]scale=720:1280:force_original_aspect_ratio=decrease,pad=720:1280:-1:-1:color=black[v" + index + "];"
        } else {
            //no need for trim
            command = command + "[" + index + ":v]scale=720:1280:force_original_aspect_ratio=decrease,pad=720:1280:-1:-1:color=black,setpts=PTS-STARTPTS,fps=24,format=yuv420p[v" + index + "];"
            if (video.a_streams > 0) {
                command = command + "[" + index + ":a]adelay=0|0[a" + audioStreams + "]";
                audioStreams = audioStreams + 1
            }
        }
        resourcePivot++
    }

    //concat videos
    for (var index = 0; index < json.videoList.length; index++) {
        command = command + "[v" + index + "]"
        if (index < audioStreams) {
            command = command + "[a" + index + "]"
        } else {
            command = command + "[" + resourcePivot + ":a]"
        }
    }
    resourcePivot++ //for dummy audio
    command = command + "concat=n=" + json.videoList.length + ":v=1:a=1[outv][outa];"
    //end of concatenation

    //voice overs
    if (json.audioList) {
        for (var index = 0; index < json.audioList.length; index++) {
            command = command + "[" + (resourcePivot + index) + "]adelay=" + json.audioList[index].start + "|" + json.audioList[index].start + "[a" + index + "];"
        }
        command = command + "[outa]"
        for (var index = 0; index < json.audioList.length; index++) {
            command = command + "[a" + index + "]"
            resourcePivot++
        }
        command = command + "amix=inputs=" + (json.audioList.length + 1) + ":duration=longest[outa];"
    }

    //bgm
    if (json.bgm) {
        command = command + "[" + resourcePivot + ":a]volume=" + json.bgmVolume + "[bgm];"
        command = command + "[outa]volume=" + json.volume + "[outa];"
        command = command + "[outa][bgm]amix=inputs=2:duration=first[outa];"
        resourcePivot++
    }

    //pip
    if (json.pip) {
        //scale pip
        command = command + "[" + resourcePivot + ":v]scale=" + (json.pip.width) + ":" + (json.pip.height) + "[pip];"
        //overlay pip audio
        if (json.pip.type != 1) {
            command = command + "[outa][" + resourcePivot + ":a]amix=inputs=2:duration=first[outa];"
        }
        //overlay pip
        command = command + "[outv][pip]overlay=" + (json.pip.x) + ":" + (json.pip.y) + ":eof_action=0[outv];"
        resourcePivot++
    }

    //images
    if (json.imageList) {
        for (var index = 0; index < json.imageList.length; index++) {
            command = command + "[" + (resourcePivot + index) + "]scale=" + (json.imageList[index].width) + ":" + (json.imageList[index].height) + "[img" + index + "];"
        }
        for (var index = 0; index < json.imageList.length; index++) {
            command = command + "[outv][img" + index + "]overlay=" + (json.imageList[index].x) + ":" + (json.imageList[index].y) + ":enable=\"\'between(t\\," + (json.imageList[index].start / 1000) + "," + (json.imageList[index].end / 1000) + ")\'\"[outv];"
        }
    }

    //remove the last semicolon
    command = command.slice(0, -1)
    command = command + " -map [outv] -map [outa] -b:v " + json.bitrate +"k -bufsize " + json.bitrate + "k -preset ultrafast -vsync 2 " + json.outputPath

    return command
}