var slardarBridge = {};

slardarBridge.checkUsedFull = function (value) {
    return typeof value !== "undefined" && value !== null && value !== "";
};

slardarBridge.isFunction = function (what) {
    return typeof what === 'function';
};

slardarBridge.appendCommonParams = function (dataObj) {
    dataObj.url = location.href;
};

slardarBridge.cover = function (dataObj, serviceStr) {
    if (!slardarBridge.checkUsedFull(dataObj)) {
        return
    }
    if (!slardarBridge.checkUsedFull(window.iesJsBridgeTransferMonitor)) {
        return
    }
    if (!slardarBridge.isFunction(window.iesJsBridgeTransferMonitor.cover)) {
        return
    }
    slardarBridge.appendCommonParams(dataObj);
    dataObj.service = serviceStr;
    var dataJson = JSON.stringify(dataObj);
    window.iesJsBridgeTransferMonitor.cover(dataJson, serviceStr);
};


slardarBridge.reportDirectly = function (dataObj, serviceStr) {
    if (!slardarBridge.checkUsedFull(dataObj)) {
        return
    }
    if (!slardarBridge.checkUsedFull(window.iesJsBridgeTransferMonitor)) {
        return
    }
    if (!slardarBridge.isFunction(window.iesJsBridgeTransferMonitor.reportDirectly)) {
        return
    }
    slardarBridge.appendCommonParams(dataObj);
    dataObj.service = serviceStr;
    var dataJson = JSON.stringify(dataObj);
    window.iesJsBridgeTransferMonitor.reportDirectly(dataJson, serviceStr);
};

slardarBridge.customReport = function (jsonObj) {
    if (!slardarBridge.checkUsedFull(jsonObj)) {
        return
    }

    if (!slardarBridge.checkUsedFull(window.iesJsBridgeTransferMonitor)) {
        return
    }
    if (!slardarBridge.isFunction(window.iesJsBridgeTransferMonitor.customReport)) {
        return
    }

    var eventName = jsonObj.eventName
    var metrics = jsonObj.metrics
    var category = jsonObj.category

    var metricJson = "";
    if (slardarBridge.checkUsedFull(metrics)) {
        metricJson = JSON.stringify(metrics);
    }

    var categoryJson = "";
    if (slardarBridge.checkUsedFull(category)) {
        categoryJson = JSON.stringify(category);
    }

    window.iesJsBridgeTransferMonitor.customReport(eventName, metricJson, categoryJson,jsonObj.canSample !== 0);
};

slardarBridge.sendInitTimeInfo = function (dataJson) {
    if (!slardarBridge.checkUsedFull(dataJson)) {
        return
    }
    if (!slardarBridge.checkUsedFull(window.iesJsBridgeTransferMonitor)) {
        return
    }
    if (!slardarBridge.isFunction(window.iesJsBridgeTransferMonitor.sendInitTimeInfo)) {
        return
    }
    window.iesJsBridgeTransferMonitor.sendInitTimeInfo(dataJson);
};

slardarBridge.reportPageLatestData = function (data) {
    if (!slardarBridge.checkUsedFull(data)) {
        return
    }
    if (!slardarBridge.checkUsedFull(window.iesJsBridgeTransferMonitor)) {
        return
    }
    if (!slardarBridge.isFunction(window.iesJsBridgeTransferMonitor.reportPageLatestData)) {
        return
    }
    data.url = location.href;
    data.resource.url = location.href;
    window.iesJsBridgeTransferMonitor.reportPageLatestData(JSON.stringify(data));
};

window.jsIESLiveTimingMonitor = slardarBridge;

if (typeof SlardarHybrid === 'function') {
    SlardarHybrid('config', {
        transport: window.jsIESLiveTimingMonitor
    });
}

//add SlardarHybrid init
window._initSlardarHybrid instanceof Function && window._initSlardarHybrid();

if (window.iesJsBridgeTransferMonitor && typeof window.iesJsBridgeTransferMonitor.injectJS === 'function') {
    try {
        window.iesJsBridgeTransferMonitor.injectJS();
    } catch (e) {}
}

//add listener to notify init time
window.addEventListener("DOMContentLoaded", function () {
    window.setTimeout(function () {
        if (window.history.length <= 1) {
            var time = performance.timing.navigationStart;
            time = time > 0 ? parseInt(time) : 0;
            slardarBridge.sendInitTimeInfo(time + "");
        }
    }, 0);
});
