local data = {
    0, 0.18006, 0.26352, -0.24341,
    10, 0.18066, 0.26589, -0.25479,
    20, 0.18133, 0.26846, -0.26876,
    30, 0.18208, 0.27119, -0.28539,
    40, 0.18293, 0.27407, -0.30470,
    50, 0.18388, 0.27709, -0.32675,
    60, 0.18494, 0.28021, -0.35156,
    70, 0.18611, 0.28342, -0.37915,
    80, 0.18740, 0.28668, -0.40955,
    90, 0.18880, 0.28997, -0.44278,
    100, 0.19032, 0.29326, -0.47888,
    125, 0.19462, 0.30141, -0.58204,
    150, 0.19962, 0.30921, -0.70471,
    175, 0.20525, 0.31647, -0.84901,
    200, 0.21142, 0.32312, -1.0182,
    225, 0.21807, 0.32909, -1.2168,
    250, 0.22511, 0.33439, -1.4512,
    275, 0.23247, 0.33904, -1.7298,
    300, 0.24010, 0.34308, -2.0637,
    325, 0.24792, 0.34655, -2.4681,
    350, 0.25591, 0.34951, -2.9641,
    375, 0.26400, 0.35200, -3.5814,
    400, 0.27218, 0.35407, -4.3633,
    425, 0.28039, 0.35577, -5.3762,
    450, 0.28863, 0.35714, -6.7262,
    475, 0.29685, 0.35823, -8.5955,
    500, 0.30505, 0.35907, -11.324,
    525, 0.31320, 0.35968, -15.628,
    550, 0.32129, 0.36011, -23.325,
    575, 0.32931, 0.36038, -40.770,
    600, 0.33724, 0.36051, -116.45,
}
local A = {{0.8951, 0.2664, -0.1614}, {-0.7502, 1.7135, 0.0367}, {0.0389, -0.0685, 1.0296}}
local B = {{0.987, -0.1471, 0.16}, {0.4323, 0.5184, 0.0493}, {-0.0085, 0.04, 0.9685}}
local P = {
    {0.4123907992659595, 0.357584339383878, 0.1804807884018343},
    {0.21263900587151036, 0.715168678767756, 0.07219231536073371},
    {0.019330818715591832, 0.11919477979462598, 0.9505321522496607}}
local Q = {
    {3.2409699419045213, -1.5373831775700935, -0.4986107602930033},
    {-0.9692436362808796, 1.8759675015077208, 0.04155505740717562},
    {0.05563007969699364, -0.20397695888897655, 1.0569715142428784}}

local Mat3xVec3 = function(mat3, vec3)
    return {mat3[1][1] * vec3[1] + mat3[1][2] * vec3[2] + mat3[1][3] * vec3[3],
            mat3[2][1] * vec3[1] + mat3[2][2] * vec3[2] + mat3[2][3] * vec3[3],
            mat3[3][1] * vec3[1] + mat3[3][2] * vec3[2] + mat3[3][3] * vec3[3]}
end

local Vec3xMat3 = function(vec3, mat3)
    return {mat3[1][1] * vec3[1] + mat3[2][1] * vec3[2] + mat3[3][1] * vec3[3],
            mat3[1][2] * vec3[1] + mat3[2][2] * vec3[2] + mat3[3][2] * vec3[3],
            mat3[1][3] * vec3[1] + mat3[2][3] * vec3[2] + mat3[3][3] * vec3[3]}
end

local Mat3xMat3 = function(mat3_1, mat3_2)
    return {Vec3xMat3(mat3_1[1], mat3_2),
            Vec3xMat3(mat3_1[2], mat3_2),
            Vec3xMat3(mat3_1[3], mat3_2)}
end

local diag = function(vec3)
    return {
        {vec3[1], 0.0, 0.0},
        {0.0, vec3[2], 0.0},
        {0.0, 0.0, vec3[3]}
    }
end

return {data, A, B, P, Q, ["Mat3xVec3"] = Mat3xVec3, ["Mat3xMat3"] = Mat3xMat3, ["diag"] = diag}