local exports = exports or {}
local Lscript = Lscript or {}
---@class Lscript:ScriptComponent 
---@field ColorTemperature number [UI(Range={2500, 10500}, Slider)]
---@field ColorTones number [UI(Range={-100, 100}, Slider)]

Lscript.__index = Lscript

function Lscript.new(construct, ...)
    local self = setmetatable({}, Lscript)
    self.ColorTemperature = 6500
    self.ColorTones = 0.0
    self.lastColorTemp = 6500
    self.lastColorTones = 0.0
    if construct and Lscript.constructor then Lscript.constructor(self, ...) end
    return self
end

local mix = function(a, b, x)
    return a * (1. - x) + b * x
end

local clamp = function(a, b, x)
    return math.min(math.max(x, a), b)
end

function Lscript:vec3Compute(x, y)
    x = 1000000.0 / x
    y = y * 0.0001
    local index = 5
    local data = self.extraData[index]
    index = index + 4
    while (data <= x and index < #self.extraData + 1) do
        data = self.extraData[index]
        index = index + 4
    end
    local factor = (data - x) / (data - self.extraData[index - 2 * 4])
    local temp_1 = {
        mix(self.extraData[index - 3], self.extraData[index - 7], factor),
        mix(self.extraData[index - 2], self.extraData[index - 6], factor),
    }
    local a = self.extraData[index - 5]
    local b = self.extraData[index - 1]
    local sqA = math.sqrt(a * a + 1.0)
    local sqB = math.sqrt(b * b + 1.0)
    local temp_2 = {
        mix(1. / sqB, 1. / sqA, factor),
        mix(b / sqB, a / sqA, factor)
    }
    factor = math.sqrt(temp_2[1] * temp_2[1] + temp_2[2] * temp_2[2])
    temp_1 = {
        y * temp_2[1] / factor + temp_1[1],
        y * temp_2[2] / factor + temp_1[2],
    }
    temp_2 = -4.0 * temp_1[2] + temp_1[1] + 2.0
    a = temp_1[1] * 1.5 / temp_2
    b = temp_1[2] / temp_2
    a = clamp(0.000001, 0.999999, a)
    b = clamp(0.000001, 0.999999, b)
    if (a + b > 0.999999) then
        local t = 0.999999 / (a + b)
        a = a / t
        b = b / t
    end
    return {a / b, 1.0, (1. - a - b) / b}
end

function Lscript:constructor()
    self.name = "scriptComp"
end

function Lscript:onStart(comp)
    self.ColorTones = 0.0
    self.ColorTemperature = 6500
    self.lastColorTemp = 6500
    self.lastColorTones = 0.0
    self.data = includeRelativePath("extraData")
    self.extraData = self.data[1]
    self.A = self.data[2]
    self.B = self.data[3]
    self.P = self.data[4]
    self.Q = self.data[5]
    self.Mat3xVec3 = self.data["Mat3xVec3"]
    self.Mat3xMat3 = self.data["Mat3xMat3"]
    self.diag = self.data["diag"]
    self.trans = comp.entity:getComponent("Transform")
    self.material = comp.entity:getComponent("MeshRenderer").material

end

function Lscript:onUpdate(comp, deltaTime)
    if self.ColorTemperature ~= 6500 or self.ColorTones ~= 0 then 
        if self.ColorTemperature == self.lastColorTemp and self.ColorTones == self.lastColorTones then
            return 
        end
        local vec3_1 = self:vec3Compute(self.ColorTemperature, self.ColorTones)
        self.lastColorTemp = self.ColorTemperature
        self.lastColorTones = self.ColorTones
        local vec3_2 = self:vec3Compute(6500, 0)
        local x_1 = self.Mat3xVec3(self.A, vec3_1)
        local x_2 = self.Mat3xVec3(self.A, vec3_2)
        local D = self.diag({x_1[1] / x_2[1], x_1[2] / x_2[2], x_1[3] / x_2[3]})
        local tmp = self.Mat3xMat3(D, self.A)
        tmp = self.Mat3xMat3(self.B, tmp)
        tmp = self.Mat3xMat3(tmp, self.P)
        tmp = self.Mat3xMat3(self.Q, tmp)
        self.material:setVec3("u_RVec3", Amaz.Vector3f(tmp[1][1], tmp[1][2], tmp[1][3]))
        self.material:setVec3("u_GVec3", Amaz.Vector3f(tmp[2][1], tmp[2][2], tmp[2][3]))
        self.material:setVec3("u_BVec3", Amaz.Vector3f(tmp[3][1], tmp[3][2], tmp[3][3]))
    else
        self.material:setVec3("u_RVec3", Amaz.Vector3f(1, 0, 0))
        self.material:setVec3("u_GVec3", Amaz.Vector3f(0, 1, 0))
        self.material:setVec3("u_BVec3", Amaz.Vector3f(0, 0, 1))
    end
    
end

function Lscript:onEvent(sys, event)
    if event.type == Amaz.AppEventType.SetEffectIntensity then
        if event.args:get(0) == "temperature_intensity" then
            local intensity = event.args:get(1) * 0.5 + 0.5
            if intensity > 0.5 then
                intensity = intensity * 0.96 + 0.02
                self.ColorTemperature = (math.pow((1. - intensity)*2, 0.3437250257)*0.5) * 4000 + 4500
            elseif intensity < 0.5 then
                self.ColorTemperature = (math.pow((1. - intensity)*2-1, 1.5)*0.5+0.5) * 8000 + 2500
            elseif intensity == 0.5 then
                self.ColorTemperature = 6500
            end
        end
        if event.args:get(0) == "tone_intensity" then
            local intensity = event.args:get(1) * 0.5 + 0.5
            self.ColorTones = intensity * 200 - 100
        end
    end
    if event.args:size() == 2 and event.args:get(0) == "reset_params" and event.args:get(1) == 1 then
        self.ColorTones = 0.0
        self.ColorTemperature = 6500
        self.lastColorTemp = 6500
        self.lastColorTones = 0.0
        self.material:setVec3("u_RVec3", Amaz.Vector3f(1, 0, 0))
        self.material:setVec3("u_GVec3", Amaz.Vector3f(0, 1, 0))
        self.material:setVec3("u_BVec3", Amaz.Vector3f(0, 0, 1))
    end
end

exports.Lscript = Lscript
return exports
