# Change Log
All notable changes to the Heap library will be documented in this file.

The format is based on [Keep a Changelog][cl] and this project adheres to
[Semantic Versioning][sv].

[cl]: http://keepachangelog.com/
[sv]: http://semver.org/


## [1.10.5] 2022-09-14
### Fixed
- Fixed a bug where a programmatic call to toggle a compound or radio button 
would be captured as a user-initiated event 
- Fixed a bug where BuildConfig class would sometimes not be found 

## [1.10.4] 2022-05-26
### Fixed
- Fixed a build failure on AGP 7.2 that occurred during Gradle project 
configuration (`java.lang.IllegalStateException: Cannot query the value of 
property 'namespace' because configuration of project has not completed yet.`) 

## [1.10.3] 2022-04-26
### Fixed
- Fixed a crash that occurred during initialization if the context that was 
obtained in our content provider was not of type Application 
(`java.lang.AssertionError: HeapAssert.fail() with throwable: 
java.lang.ClassCastException: {type} cannot be cast to 
android.app.Application`) 

## [1.10.2] 2022-03-30
### Fixed
- Fixed a build failure that occurred when building with dependencies that 
contained classes with case-insensitive naming collisions (e.g. 
`com.example.myClass` and `com.example.MyClass`) 

## [1.10.1] 2022-02-16
### Fixed
- Fixed a build failure that occurred with dependencies built with Java 16 
(`java.lang.IllegalArgumentException: Unsupported class file major version 60`) 

## [1.10.0] 2022-01-31
### Added
- Added new `Heap.getSessionId` API method to retrieve session ID 
### Changed
- Added headers to all EV requests to specify app version 
(`--x-heap-app-version`), Heap env ID (`--x-heap-env-id`), and EV request 
message type (`--x-heap-ev-request-type`) 

## [1.9.4] 2021-12-15
### Fixed
- Fixed an assertion error that would occur if a user interacted with a UI 
element in an app while the app was in the background 
- Fixed a Bluetooth `SecurityException` that would occur in Android 12 in apps 
that did not have the `BLUETOOTH_CONNECT` permission 

## [1.9.3] 2021-08-30
### Added
- Added support for AGP 7 
### Fixed
- Fixed a NPE that would occur in the library if a FragmentActivity was created 
outside of the main app process 
- Fixed a duplicate resource issue that would prevent apps from rebuilding 
without an intermediate clean step 
- Fixed a bug that caused the Gradle plugin not to inject build config 
information into the app with AGP 7 
- Replaced usage of deprecated `getMappingFile` method with 
`getMappingFileProvider` 

## [1.9.2] 2021-06-07
### Fixed
- Fixed an issue where the Gradle plugin would fail with AGP 4.2 due to an 
IllegalStateException ("The value for property
 'resValues' cannot be changed any further.") 

## [1.9.1] 2021-04-14
### Fixed
- Fixed an issue where the library would leak memory due to stale `TabView` and 
`ItemView` instances not being garbage-
 collected 
- Fixed an issue where hierarchies provided by Heap's React Native SDK would be 
truncated on Android devices 

## [1.9.0] 2021-03-11
### Added
- Added API methods to disable and enable tracking for individual users 
### Fixed
- Fixed an issue where app builds would fail if duplicate protobuf file names 
existed in dependencies 

## [1.8.1] 2020-12-07
### Fixed
- Fixed an issue where library would bail if `TabLayout`s were rendered
 prior to Heap initialization 

## [1.8.0] 2020-09-14
### Added
- Added property to track whether an event occurred while the app was in
 the foreground or background 
- Added target resource ID property to clicks on Androidx and Support
 Library menu items 
### Fixed
- Fixed an issue where automatic item selection in Spinner UI elements
 would result in a click event 
- Fixed an issue where TLSv1.2 encryption was not being enabled for SSL
 connections on API levels below 21 
- Fixed an issue where library would bail on API levels below 21 when
 events were sent to the Event Visualizer 

## [1.7.2] 2020-12-07
### Fixed
- Fixed an issue where library would bail if `TabLayout`s were rendered
 prior to Heap initialization 

## [1.7.1] 2020-07-22
### Fixed
- Heap correctly instruments events that are handled by Java 8 lambdas 
- Heap's Gradle plugin is now compatible with Android Gradle Plugin 4.0.0 

## [1.7.0] 2020-05-10
## Changed
- It is now possible to initialize Heap at any point in the app's lifecycle,
 enabling selective initialization based on feature flags 

## [1.6.0] 2020-03-20
### Added
- Heap now includes the Android ID (SSAID) and Android Advertiser ID as event
 and user properties 
- Target views for events and their ancestors now include bounding box data for
 better event definitions in the Android Event Visualizer 
### Fixed
- Fixed an issue where a duplicate page view event was sent when coming back to
 the app after the session timeout 
- Fixed a potential null pointer exception in Heap's fragment lifecycle
 tracking 
- Fixed some incompatibilities with Android API levels 16-18 
- Fixed an issue where page view events would appear out of order in the
 Android Event Visualizer after a session refresh 
- Fixed an issue where events would be populated with stale page view
 information after a session refresh 

## [1.5.0] 2020-02-05
### Added
- Added capability to capture events without capturing text content
 of views; this can be enabled by setting `ext.heapDisableTextCapture`
 to true on a build type or flavor in the Gradle config

## [1.4.1] 2020-01-30
### Fixed
- Fixed builds failing on Windows with inability to modify a resource jar file 

## [1.4.0] 2019-12-05
### Added
- Added logic to send ancestors of target views for better event definition in 
the Event Visualizer 
### Fixed
- Added logic to deobfuscate obfuscated View and Fragment classes 

## [1.3.0] 2019-11-14
### Added
- Heap Gradle plugin now supports building under Windows
### Changed
- Gradle plugin now works on JVM bytecode instead of DEX, replacing Redex and
 resolving a host of related build and capture issues 
- Shade all dependencies of the Gradle plugin to fix various dependency issues 

## [1.2.0] 2019-09-27
### Added
- Added `getUserId` and `getIdentity` methods to retrieve numeric user ID and
 identity respectively 
### Fixed
- Fixed a runtime failure where Heap would immediately shut down upon 
initialization
 for obfuscated builds 
- Fixed a build-time failure for apps that contained Firebase or other 
dependencies that
 used protobuf-lite 
- Fixed a runtime crash that occurred on API levels older than 24 

## [1.1.1] 2019-08-16
### Changed
- Heap client library now depends on protobuf-javalite 3.9.0; apps that depend
 on the full protobuf-java library can now build without duplicate class
 conflicts by excluding the dependency on protobuf-javalite 
### Fixed
- Fixed build failure for AAB builds if there was no signing config
 
- Fixed and issue where Heap plugin would fail for AAB builds if the bundle
 task depended on the package task 
- Fixed an issue where Heap never resumes sending events after a
 fragment-based app's process is terminated while it is backgrounded; this
 often happened on Samsung devices, as the Optimize feature of Device Care
 will terminate processes for all backgrounded apps. 

## [1.1.0] 2019-06-29
### Changed
- Sessions now last for five minutes since the last interaction, instead of
 restarting whenever the app reenters the foreground 

## [1.0.1] 2019-06-29
### Fixed
- Fixed an issue building an AAB when there are spaces in the path to
 jarsigner 
- Fixed an issue where building an AAB could hang for a long time on
 subsequent builds 

## [1.0.0] 2019-06-13
### Added
- Android Event Visualizer to make defining events easier; see
 
https://help.heap.io/heap-administration/data-management/event-visualizer/#tab--
android for more. 
- Autocapture app install and upgrade events. 
### Changed
- When changing between activities, Heap now captures a single fragment
 transition event instead of one for each of the stopping and starting
 activities. 
### Fixed
- Fix issue where proguard throws build error because it cannot find
 `sun.misc.Unsafe` class referenced by protobuf. 
- Fix issue where gradle builds fail when Heap is disabled due to missing
 manifest placeholder. 
- Fix issue where null fragments would cause Heap to shut down. 
- Fix an issue where the Gradle plugin throws a NullPointerException if there
 are any `files()` dependencies. 
- Fix an issue where the Gradle plugin could result in attempting to
 create a dex with over 64k method references. 

## [0.9.1] 2019-03-22
### Fixed
- Fix issue where null fragments would cause apps to crash. [HEAP-8475, 
HEAP-8477]

## [0.9.0] - 2019-03-20
A critical issue was identified in this release, and it is not recommended to
use this version of the SDK.
### Added
- Allow ignoring events from parts of the view hierarchy, both declaratively
 via XML view tags, and programmatically by calling `Heap.ignore()` on the
 view. 
- Capture page transition events for changes to the visible page in a
 ViewPager 
- Heap now captures events for androidx equivalents of support library
 elements. 
### Changed
- Heap is now enabled by the setting `ext.heapEnabled` instead of the the
 `enabled` key in the `ext.heap` map. Both locations are consulted for
 compatibility, but the `ext.heap` map location is deprecated. 
- The Heap Gradle plugin can now also be applied before the Android Gradle
 plugin if using Gradle >= 4.8. 
- The Heap Gradle plugin attempts to reduce configuration overhead by using
 the task configuration avoidance APIs when used with Android Gradle Plugin
 versions 3.3 and higher. 
### Deprecated
- Enabling Heap via `ext.heap = ["enabled": true]` is deprecated and will be
 removed in a future version; use `ext.heapEnabled` instead. 
- Support for Android Gradle Plugin versions earlier than 3.0.0 is deprecated
 and will be removed in a future release.
### Fixed
- Fix an issue with `EditText` change events sometimes having incorrect
 timestamps, leading to dropped events. 
- Fix potential issue with tracking changes to set of visible fragments.

## [0.8.3] - 2019-01-23
### Added
- Text changes in EditText fields are now captured if they have at least one 
TextWatcher added 
- The user identity can now be reset to an anonymous state with 
`Heap.resetIdentity()` 
- The Heap library now specifies a minimum SDK version of 14 to match our 
actual use of platform libraries 
### Changed
- Request bodies are now compressed with gzip for size efficiency 

## [0.8.2] - 2019-01-05
### Added
- Heap client library now specifies a target SDK version, which prevents the
 manifest merger from automatically adding the implicit system permissions
 `READ_PHONE_STATE`, `READ_EXTERNAL_STORAGE`, and `WRITE_EXTERNAL_STORAGE` to
 users' apps 

## [0.8.1] - 2018-12-17
### Fixed
- Heap plugin works for Android Gradle Plugin version 3.2.1. 
- Heap plugin instruments Android App Bundles (note: dynamic modules are not 
supported). 

## [0.8.0] - 2018-12-05
### Added
- Heap now autotracks when fragments are added or removed from view, and
 includes visible fragments as an event property on all events 
### Changed
- Heap plugin looks for the heap extension on flavors and default config as
 well as build types 
- The Gradle plugin will error out if used with Android Gradle Plugin 3.2.0 or
 higher. This is a temporary measure as we add compatibility for AGP 3.2+ and
 app bundles. 
### Removed
- Heap no longer sends session and pageview events if the build plugin did not
 apply Heap properly, or if the app is running under instant run. This was
 confusing when troubleshooting, as seeing some events could make it look like
 Heap was installed properly when it was not. 
### Fixed
- Fixed an issue with the included proguard rules that could result in a
 NoSuchMethodError at runtime 

## [0.7.5] - 2018-10-15
### Added
- Proguard rules are now bundled in the client library, removing the need to
 add them manually when integrating 
- Heap plugin now instruments clicks on ActionMenuViews 
- Heap plugin now instruments clicks on links in TextViews 
- Heap plugin checks the minSdkVersion before building to avoid confusing dex 
magic errors 
### Changed
- Heap plugin logs a warning if the variant being built doesn't have Heap
 enabled 
- Heap Android artifacts are now available on jcenter 
### Fixed
- Removed some blocking IO from the Heap.init() call path 

## [0.7.4] - 2018-09-06
### Added
- Heap plugin now instruments BottomNavigationView clicks 
### Changed
- Custom events can now be sent from the background 

## [0.7.3] - 2018-08-27
### Fixed
- Heap library now shades its well-known protobuf types, preventing clashes 
with other libraries, eg Firebase Firestore and Firebase In-App Messaging. 

## [0.7.2] - 2018-08-17
### Added
- Heap plugin now instruments TabHost clicks. 
### Changed
- Heap library now includes device form factor with event data. 

## [0.7.1] - 2018-07-17
### Changed
- Read the complete response body from the Heap endpoint, and close the 
response stream. This should reduce the number of 'socket not closed' warnings 
### Fixed
- Heap.identify triggers as expected when called immediately after Heap.init. 

## [0.7.0] - 2018-05-11
### Added
- Include gradle tasks to print individual licenses used by library. For a list 
of tasks, run `./gradlew tasks` and refer to the "Heap tasks" section. 
- Include this changelog in the released JAR files
- Support Linux build environments 
### Fixed
- Properly fail build if instrumentation fails 
- Fix an issue where dexes numbered above 99 were not included in the 
instrumented APK 
- Fix issue with 400 response codes from track endpoint

## [0.6.0] - 2018-03-26
### Changed
- Heap plugin now immediately aborts with clear exception message on non-macOS 
platforms 
### Removed
- `Heap.setEnvId` and `Heap.setInterval` methods 
### Fixed
- Fix typo in Heap Build Log Warning message about enabling Heap (comma should 
have been a colon).
- Fix bug that prevented apps from building in Android Studio 3 when Instant 
Run was enabled.

## [0.5.2] - 2018-03-08
### Fixed
- Fix BuildConfig error that occurs in Gradle versions 4.1 and higher by 
removing resource value injection out of variant prebuild doFirst action block 
and into general afterEvaluate block of HeapPlugin.apply method 
- Fix add user properties 
- Fix socket resource StrictMode violation 

## [0.5.1] - 2018-03-01
### Added
- Debug information on BuildConfig error 

## [0.5.0] - 2018-02-13
### Added
- Capture Android toggle switches 
- Capture Android radio buttons 

### Fixed
- Fix uncaught exceptions 
