/*
Hash of this file is whitelisted on BE side now. If you need to change this file, you have to
notice Help Center web team and provide them new hash. If you just update this file without
update whitelist on BE - it will not work.
*/
var ArloExtension = (function() {

    var _callbacks = [];

    var _iOS = (function () {
        var isSupported = function () {
            return window.webkit && window.webkit.messageHandlers && /iPhone|iPod|iPad/.test(navigator.platform) || (navigator.platform === 'MacIntel' && navigator.maxTouchPoints > 1);
        };

        var sendMessage = function(message) {
            window.webkit.messageHandlers.ArloExtension.postMessage(message);
        };

        return {
            isSupported: isSupported,
            sendMessage: sendMessage,
        }
    })();

   var _android = (function () {
        var isSupported = function () {
            return typeof AndroidJsBridge != "undefined"
        };

        var sendMessage = function(message) {
            AndroidJsBridge.postMessage(JSON.stringify(message))
        };

        return {
            isSupported: isSupported,
            sendMessage: sendMessage,
        }
    })();

    var sendMessage = function(action, message, callback) {
        var transactionId = 'ext|' + _uuid()
        if (callback) {
            _callbacks[transactionId] = callback;
        }

        if (_iOS.isSupported()) {
            _iOS.sendMessage({
                'action': action.toString(),
                'message': message,
                'transactionId': transactionId
            });
            return true;
        } else if (_android.isSupported()) {
            _android.sendMessage({
                'action': action.toString(),
                'message': message,
                'transactionId': transactionId
            });
        } else {
            console.log('WebKit support is not present');
            return false;
        }
    };

    var getProperty = function (propertyName, callback) {
        sendMessage('get', { 'property': propertyName }, callback);
    };

    var setProperty = function (propertyName, newValue, callback) {
        sendMessage('set', { 'property': propertyName, 'value': newValue }, callback);
    };

    var onCallback = function(transactionId, response) {
        if (response.error) {
            console.log(response.error);
        }
        if (transactionId && _callbacks[transactionId]) {
            _callbacks[transactionId](response);
            delete _callbacks[transactionId];
        }
    };

    var _uuid = function () {
        var dt = new Date().getTime();
        var uuid = 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(c) {
            var r = (dt + Math.random()*16)%16 | 0;
            dt = Math.floor(dt/16);
            return (c=='x' ? r :(r&0x3|0x8)).toString(16);
        });
        return uuid;
    };

    return {
        getProperty: getProperty,
        setProperty: setProperty,
        sendMessage: sendMessage,
        onCallback: onCallback
    }
})();