#!/bin/bash
set -e
TRANSLATION_PATH="$PWD/tts/gen/"
mkdir -p build || true
ROOT_DIR=$PWD
cd build
find . -name "*.gcda" -print0 | xargs -0 rm -f
cmake -DCMAKE_BUILD_TYPE=Debug "$ROOT_DIR/test/"
make
unamestr=$(uname)
if [[ "$unamestr" == "Darwin" ]]; then
    XC_PREFIX="xcrun"
else
   XC_PREFIX=""
fi
./unit_tests "$TRANSLATION_PATH" --gtest_output=xml --gmock_verbose=error
$XC_PREFIX llvm-profdata merge -sparse default.profraw -o default.profdata
$XC_PREFIX llvm-cov show -format=html -instr-profile=default.profdata unit_tests "$ROOT_DIR/src" > coverage.html
$XC_PREFIX llvm-cov export -instr-profile=default.profdata unit_tests > coverage.json
cd ..
gcovr -r . --xml --exclude="test|deps|src/interface|src/json_gen" --gcov-executable "$PWD"/scripts/gcov -o build/coverage.xml