#!/bin/sh

# This script creates an iOS Simulator-only set of fat binaries for use by the xctest_runner bundle.
# It is run as a Build Phase script prior to the 'Link Binary with Libraries' phase

set -e 
set -o pipefail

GC_LIB_PATH=$PROJECT_DIR/deps/gc_lib/ios/Release
GC_ARTIFACT_SUBDIR="iphonesimulator"
rm -rf ${GC_LIB_PATH}/${GC_ARTIFACT_SUBDIR}
mkdir -p ${GC_LIB_PATH}/${GC_ARTIFACT_SUBDIR}

# using the list of artifacts in the 'ios_sim' directory, create fat binaries for each one, using the artifacts in all the simulator arch dirs
for f in `ls ${GC_LIB_PATH}/ios_sim`;do
    lipo ${GC_LIB_PATH}/ios_sim/$f \
        ${GC_LIB_PATH}/ios_sim64/$f \
        ${GC_LIB_PATH}/ios_simarm64/$f \
        -create -output ${GC_LIB_PATH}/${GC_ARTIFACT_SUBDIR}/$f
done

