#!/bin/sh
set -e
set -o pipefail
set -u

function finish {
    dt=$SECONDS
    ds=$((dt % 60))
    dm=$(((dt / 60) % 60))
    dh=$((dt / 3600))
    printf 'total time: %02d:%02d:%02d\n' $dh $dm $ds
}
trap finish EXIT

PLATFORM=${1-""}

if [ "$PLATFORM" = "" -o "$PLATFORM" = "ios" ]; then
    echo "Running dry run for iOS"
    ./scripts/dryrun-ios.sh
fi

if [ "$PLATFORM" = "" -o "$PLATFORM" = "android" ]; then
    echo "Running dry run for Android"
    docker rmi $(docker images -q -f dangling=true) || true
    docker rm $(docker ps -a -f name=elcamino -q) || true
    docker build -t elcamino_android -f scripts/Dockerfile .
    docker run --name elcamino_android_release -v $PWD/build:/elcamino/build  elcamino_android:latest ./scripts/dryrun-android.sh
    docker rm $(docker ps -a -f name=elcamino -q)
fi