#!/usr/bin/env python3

import sys
import getopt
import re
import json


def usage():
    print("Usage: ./scripts/coverage_summary.py --include source_folder coverage.json")

def parseInput(data, include):
    files = data.get("data")[0].get("files")
    summary = {"files": {}}
    total = 0
    covered = 0
    includeRegex = "^(" + ("|".join(include)) + ")"
    for f in files:
        filename = f.get("filename")
        if re.match(includeRegex, filename):
            fileSummary = f.get("summary")
            summary.get("files")[filename] = fileSummary
            total = total + fileSummary.get("lines").get("count")
            covered = covered + fileSummary.get("lines").get("covered")

    summary["average"] = covered / total
    summary["total"] = total
    summary["covered"] = covered
    return summary

def main():
    # parse command args
    try:
        opts, args = getopt.getopt(sys.argv[1:], "hi:", ["help", "include="])
    except getopt.GetoptError as e:
        print(e)
        usage()
        sys.exit(1)

    include = []
    inputFile = sys.argv[-1]
    summary = {}

    for opt, arg in opts:
        if opt in ("-h", "--help"):
            usage()
            sys.exit(0)
        elif opt in ("-i", "--include"):
            include = arg.split(",")

    # required args
    if inputFile == None:
        usage()
        sys.exit(1)

    # get schema from file
    with open(inputFile, "r") as fp:
        raw = "".join(fp.readlines())
        schema = json.loads(raw)
        summary = parseInput(schema, include)

        print("Coverage {}/{} = {}".format(summary["covered"], summary["total"], summary["average"]))

if __name__ == "__main__":
    main()
