namespace com.amazon.helperdomainservice.messagebus

structure GetProviderDetailsDocumentRequest {
    @required
    @documentation("Contains message level metadata used to coordinate between request and response")
    messageMetadata: MessageMetadata,

    @documentation("Used to determine if HelperDomainService has different version of the document.
    If the version provided is different than what HelperDomainService has, new document version is returned.
    If the version is the same, no document is returned to save traffic.")
    version: String,

    @required
    @documentation("TSMS Session Id of the provider that sends this message.")
    sessionId: String
}
