namespace com.amazon.helperdomainservice.messagebus

structure ProviderDetailsDocument {
    @required
    @documentation("Clients should use this version attribute as an etag when requesting an update")
    version: String,

    @required
    @documentation("Timestamp in epoch millis of when we took the snapshot of this document")
    snapshotTimestamp: Long,
    @documentation("Used to determine how many helpers are expected to be paired with the driver.
    HDS will not allow to pair with more helpers than expectedNumberOfHelpers.")
    expectedNumberOfHelpers: Integer,

    @documentation("Contains helperHdsDirectedIds which were already paired with the driver.
    HDS directedId is created by HelperDomainService and doesn't match with the rest of directedIds.")
    pairedHelperHdsDirectedIds: PairedHelperHdsDirectedIdsList,

    @documentation("Used to determine the weblab version for both driver and helper")
    weblabOption: WeblabOption,

    @documentation("Contains driver details")
    driver: ProviderDetails,

    @documentation("Contains helpers details")
    helpers: ProviderDetailsList
}

structure WeblabOption {
    wotaVersion: String,

    @documentation("This is a shared directedId and it's different from hdsDirectedId")
    driverDirectedId: String
}

list PairedHelperHdsDirectedIdsList {
    member: String
}

list ProviderDetailsList {
    member: ProviderDetails
}

structure ProviderDetails {
    hdsDirectedId: String,

    @documentation("WorkHourContext - https://tiny.amazon.com/1ixabeg79/codeamazpackblob2dd2modexml")
    workHourContext: String,

    @documentation("Short string that maps to a sessionId of the provider. This is the string that is encoded in the QR code.")
    shortSessionId: String,

    @documentation("isCurrent could be used to identify ProviderDetails of a logged in provider")
    isCurrent: Boolean
}
