namespace com.amazon.helperdomainservice.messagebus

@documentation("Contains message level metadata used to coordinate between request and response")
structure MessageMetadata {
    @required
    @documentation("An id uniquely identifying the request. It remains the same across soft timeouts and retries.")
    correlationId: String,

    @required
    @documentation("The server-synchronised epoch in millis of when the Rabbit application attempted to submit the request.")
    submitTimestamp: Long,

    @required
    @documentation("The amount of time remaining in millis after which the rabbit workflow will abandon the request
     and ignore any response with the correlationId")
    timeoutLeft: Integer
}
