
DROP TABLE IF EXISTS document;
CREATE TABLE IF NOT EXISTS document(
    _documentid TEXT NOT NULL PRIMARY KEY UNIQUE,
    contentversion INTEGER NOT NULL,
    contenttype TEXT NOT NULL,
    contentdata TEXT NOT NULL,
    contentrevision INTEGER NULL,
    document_last_update_time INTEGER NOT NULL,
    etag TEXT NOT NULL
);

DROP TABLE IF EXISTS instruction;
CREATE TABLE IF NOT EXISTS instruction(
  _instructionid TEXT NOT NULL PRIMARY KEY UNIQUE,
  documentid TEXT NOT NULL,
  type TEXT NOT NULL,
  instructionstatusfromserver TEXT NOT NULL,
  typeparams TEXT,
  typeversion INTEGER,
  required TEXT NOT NULL,
  onsuccess TEXT,
  onfailure TEXT
);

DROP TABLE IF EXISTS event;
CREATE TABLE IF NOT EXISTS event(
  _eventid TEXT NOT NULL PRIMARY KEY UNIQUE,
  eventdocumentid TEXT,
  eventtimestamp INTEGER NOT NULL,
  eventsenttimestamp INTEGER,
  eventinstructionid TEXT,
  eventpayload TEXT NOT NULL,
  eventuploadattempts INTEGER,
  eventappinstanceid TEXT NOT NULL
);

DROP TABLE IF EXISTS instruction_results;
CREATE TABLE IF NOT EXISTS instruction_results(
   _instructionid NOT NULL PRIMARY KEY UNIQUE,
   instructionstatus TEXT
);

DROP VIEW IF EXISTS instruction_update;

CREATE VIEW instruction_update AS SELECT
instruction.*, instruction_results.instructionstatus
FROM instruction
LEFT OUTER JOIN instruction_results
ON instruction._instructionid = instruction_results._instructionid
;

DROP VIEW IF EXISTS instruction_documentinfo;

CREATE VIEW instruction_documentinfo AS SELECT
document.*, instruction._instructionid
FROM document
LEFT OUTER JOIN instruction
ON instruction.documentid = document._documentid
;

DROP TABLE IF EXISTS genericAssets;
CREATE TABLE IF NOT EXISTS genericAssets(
    _key STRING NOT NULL PRIMARY KEY UNIQUE,
    generic_asset_url STRING NOT NULL,
    generic_asset_blob BLOB NOT NULL,
    generic_asset_documentid STRING NOT NULL,
    generic_asset_documentrevision INTEGER NULL,
    generic_asset_numberofattempts INTEGER
);
