#!/bin/sh

# This script takes the artifacts generated by the elcamino.xcodeproj project and
# GClib to assemble the final framework

set -e

# process the artifacts for the different platforms
GC_LIB_PATH=$PROJECT_DIR/../../../deps/gc_lib/ios/Release
case $PLATFORM_NAME in
    "iphoneos")
        GC_ARTIFACT_SUBDIR="ios_device"
        ;;
    
    "iphonesimulator") # these are currently stored in separate folders, by architecture
        GC_ARTIFACT_SUBDIR="iphonesimulator"
        mkdir -p ${GC_LIB_PATH}/${GC_ARTIFACT_SUBDIR}
        for f in `ls ${GC_LIB_PATH}/ios_sim`;do
            lipo ${GC_LIB_PATH}/ios_sim/$f \
                ${GC_LIB_PATH}/ios_sim64/$f \
                ${GC_LIB_PATH}/ios_simarm64/$f \
                -create -output ${GC_LIB_PATH}/${GC_ARTIFACT_SUBDIR}/$f
        done
    ;;
    
    *)
        echo "Unsupported platform '${PLATFORM_NAME}', exiting."
        exit 1
esac

# link against the GClib and ElCamino C++ artifacts for the desired architectures
FRAMEWORK=$BUILT_PRODUCTS_DIR/$CONTENTS_FOLDER_PATH
echo "Subdir for platform '$PLATFORM_NAME', variant '$CURRENT_VARIANT': '${GC_ARTIFACT_SUBDIR}'"
libtool -static -no_warning_for_no_symbols \
-o $FRAMEWORK/ElCamino \
$BUILT_PRODUCTS_DIR/libelcamino_objc.a \
$BUILT_PRODUCTS_DIR/libelcamino.a \
$BUILT_PRODUCTS_DIR/libdjinni_objc.a \
$BUILT_PRODUCTS_DIR/libjson11.a \
$GC_LIB_PATH/$GC_ARTIFACT_SUBDIR/libShortestPathCoreCpp.a \
$GC_LIB_PATH/$GC_ARTIFACT_SUBDIR/libboost_iostreams.a \
$GC_LIB_PATH/$GC_ARTIFACT_SUBDIR/libboost_system.a \
$GC_LIB_PATH/$GC_ARTIFACT_SUBDIR/libjson-matcher.a \
$GC_LIB_PATH/$GC_ARTIFACT_SUBDIR/libsxdb.a \
$GC_LIB_PATH/$GC_ARTIFACT_SUBDIR/libboost_filesystem.a \
$GC_LIB_PATH/$GC_ARTIFACT_SUBDIR/libboost_smart_ptr.a \
$GC_LIB_PATH/$GC_ARTIFACT_SUBDIR/libguide.a \
$GC_LIB_PATH/$GC_ARTIFACT_SUBDIR/libmaps-commons.a

# now generate the Umbrella header contents from the generated Djinni types
HEADERS_PATH=$BUILT_PRODUCTS_DIR/$PUBLIC_HEADERS_FOLDER_PATH
mkdir -p $HEADERS_PATH

GLOBIGNORE="*Private*";

UMBRELLA=$FRAMEWORK/Headers/ElCamino.h
echo "// ElCamino Umbrella Header" > $UMBRELLA

for f in $PROJECT_DIR/../ElCaminoLib/gen/*.h; do
filename=`basename $f`
echo "#import <ElCamino/$filename>" >> $UMBRELLA
cp $f $HEADERS_PATH
done

#for f in $PROJECT_DIR/../ElCaminoLib/src/*.h; do
#    filename=`basename $f`
#    echo "#import <ElCamino/$filename>" >> $UMBRELLA
#    cp $f $HEADERS_PATH
#done

mkdir -p $FRAMEWORK/Modules
MODULE_MAP=$FRAMEWORK/Modules/module.modulemap
cat > $MODULE_MAP <<EOL
framework module ElCamino {
    umbrella header "ElCamino.h"
    
    export *
    module * { export * }
}
EOL
