#!/bin/sh

set -e
set -o pipefail
set -u

NAME=ElCamino
OUTPUT=build/ios/pkg
DERIVED_DATA=build/ios
PRODUCTS=${DERIVED_DATA}
rm -rf $OUTPUT
BUILD_FOR_DEVICE=${BUILD_DEVICE:-true}
SYMBOLS=${SYMBOLS:-YES}

function step { >&2 echo -e "\033[1m\033[36m* $@\033[0m"; }
function finish { >&2 echo -en "\033[0m"; }
trap finish EXIT
xbprettifier=xcpretty >/dev/null 2>&1 && echo "xcpretty -c" || echo "cat"

step "building for iOS Simulator"
xcodebuild -project platform/ios/ElCaminoFramework/ElCamino.xcodeproj -configuration Release  -sdk iphonesimulator -target ElCamino SYMROOT=$PWD/build | ${xbprettifier}

step "building for iOS device"
xcodebuild -project platform/ios/ElCaminoFramework/ElCamino.xcodeproj -configuration Release  -sdk iphoneos -target ElCamino SYMROOT=$PWD/build | ${xbprettifier}

step "assembling framework"
mkdir -p ${OUTPUT}

FRAMEWORK=${OUTPUT}/${NAME}.framework
cp -v -R build/Release-iphoneos/${NAME}.framework ${FRAMEWORK}

libtool -static -no_warning_for_no_symbols \
            -o $FRAMEWORK/${NAME} \
            build/Release-iphoneos/ElCamino.framework/ElCamino \
            build/Release-iphonesimulator/ElCamino.framework/ElCamino

step "Copying resources"
cp -v -R build/Release-iphoneos/Resources.bundle $OUTPUT/Resources.bundle

step "done!"
