#!/bin/sh

# Builds iOS framework, and copies files to the location expected by a brazil workspace.  This allows
# building of consumers in a brazil workspace without requiring remote Jenkins builds.

set -e
set -o pipefail
set -u

echo "cleaning existing build artifacts"
# Don't use 'make clean', as it removes the symlink brazil creates to the workspace 'build' directory
rm -rf build/*

echo "Building iOS Libraries"
git submodule update --init  --recursive --force --depth 200
make ios
echo "Copying build artifacts to expected location"
BRAZIL_BUILD_DIR=$(brazil-path package-build-root)
CUR_DIR=$PWD

cd build/ios/pkg/
tar -cvzf $BRAZIL_BUILD_DIR/ElCamino.framework.tar.gz ElCamino.framework Resources.bundle
cd $CUR_DIR
