namespace com.amazon.helperdomainservice.messagebus

structure PairWithHelperResponse {
    @required
    @documentation("Contains message level metadata used to coordinate between request and response")
    messageMetadata: MessageMetadata,

    @required
    @documentation("Records could be populated even if response status is a FAILURE")
    records: PairWithHelperResponseRecordList,

    @documentation("
        This status is global for the response. Status will be SUCCESS only if all the
        provided helpers are successfully paired.
    ")
    @required
    status: ResponseStatus,

    @documentation("FailureReason will only be provided if status != SUCCESS")
    failureReason: PairWithHelperAggregatedFailureReason
}

structure PairWithHelperResponseRecord {
    @required
    status: ResponseStatus,

    @documentation("FailureReason will only be provided if status != SUCCESS")
    failureReason: PairWithHelperFailureReason,

    @required
    helperShortSessionId: String
}

list PairWithHelperResponseRecordList {
    member: PairWithHelperResponseRecord
}

@enum(
    helper_already_paired: {
        name: "HELPER_ALREADY_PAIRED"
    },
    helper_is_not_assigned_to_driver: {
        name: "HELPER_IS_NOT_ASSIGNED_TO_DRIVER"
    },
    invalid_driver_session: {
        name: "INVALID_DRIVER_SESSION"
    },
    invalid_helper_session: {
        name: "INVALID_HELPER_SESSION"
    },
    exceeded_expected_number_of_helpers: {
        name: "EXCEEDED_EXPECTED_NUMBER_OF_HELPERS"
    },
    system_error: {
        name: "SYSTEM_ERROR"
    },
    invalid_input: {
        name: "INVALID_INPUT"
    }
)
string PairWithHelperFailureReason


@enum(
    invalid_driver_session: {
        name: "INVALID_DRIVER_SESSION"
    },
    system_error: {
        name: "SYSTEM_ERROR"
    },
    invalid_input: {
        name: "INVALID_INPUT"
    },
    at_least_one_helper_failed_to_pair: {
        name: "AT_LEAST_ONE_HELPER_FAILED_TO_PAIR"
    }
)
string PairWithHelperAggregatedFailureReason
