namespace com.amazon.helperdomainservice.messagebus

@documentation("If status = SUCCESS, document will be populated and failureReason will be null.
 In other cases document will be null and failureReason will be present.")
structure GetProviderDetailsDocumentResponse {
    @required
    @documentation("Contains message level metadata used to coordinate between request and response")
    messageMetadata: MessageMetadata,

    document: ProviderDetailsDocument,
    status: ResponseStatus,
    failureReason: GetProviderDetailsDocumentFailureReason
}

@enum(
    invalid_session: {
        name: "INVALID_SESSION"
    },
    system_error: {
        name: "SYSTEM_ERROR"
    }
)
string GetProviderDetailsDocumentFailureReason
