var PICK_SRC_SEARCH = 0;
var PICK_SRC_RELATED = 1;

/**
 * Gets the body from the native code and displays it
 */
function loadMessageBody() {
    var composeContentEl = document.getElementById(COMPOSE_CONTENT_ELEMENT_ID),
        imageController = new ImagesController();

    composeContentEl.innerHTML = yMailBridge.getContent();
    // Attach image controller
    imageController.attachAllImages();

    // wait for attachmentsController and stationery to be loaded
    utils.onDomContentLoaded(function() {
        // If there is stationery already applied in current draft, set stationery ID
        var currentStationeryId = Stationery.currentAppliedTheme();

        if (currentStationeryId === Stationery.constants.noneStationeryThemeId) {
            currentStationeryId = "NONE";
        }

        yMailBridge.setStationeryId(currentStationeryId);
        // After message body is loaded. Rebind the stationery context
        Stationery.initialize();
        attachmentsController.initAttachmentCards(composeContentEl);
    });
}

/**
 * Sets the from address
 * @param address the email address to be set
 */
function setFromAddress(address) {
    ccBccFromSummaryFieldController.setFromAddress(address);
}

/**
 * Sets the subject. Usually used after the activity is being restored from a configuration change such as device rotation.
 * @param subject the subject string
 */
function setSubject(subject) {
    subjectTextController.setSubject(utils.unescapeHtml(subject));
}

/**
 * Sets the focus on the element with the given id. Usually used after being restored from a configuration change.
 * @param elementId the id of the element on which focus should be set.
 */
function setFocus(elementId) {
    var nodeToFocus = document.getElementById(elementId);
    if (nodeToFocus) {
        // For to/cc/bcc, the parent node is hidden by default
        if (elementId === TO_INPUT_ELEMENT_ID ||
            elementId === CC_INPUT_ELEMENT_ID ||
            elementId === BCC_INPUT_ELEMENT_ID) {
            nodeToFocus.parentNode.classList.remove("hidden");
        }

        nodeToFocus.classList.remove("hidden");
        setTimeout(function() {
            nodeToFocus.focus();
        }, 100);
    }
}

/**
 * Sets the cursor at the position for elementId
 * @param elementId: the id of the element on which cursor should be set.
 * @param nodeText: text of the node.
 * @param position: position of the cursor in the node.
 */
function setBodyFocusAtPosition(elementId, nodeText, position) {
    composeContentFocusController.setBodyFocusAtPosition(elementId, nodeText, position);
}

/**
 * Sets the focus on the To recipient field
 */
function setFocusOnToRecipientField() {
    var toInputNode = document.getElementById(TO_INPUT_ELEMENT_ID);
    if (toInputNode) {
        // Make sure the lozenges are expanded otherwise the input field will be hidden
        lozengeController.expandLozenges(TAG_TO_RECIPIENT);
        toInputNode.focus();
    }
}

/**
 * Sets the focus on the body field
 */
function setFocusOnBody() {
    var bodyNode = document.getElementById(COMPOSE_CONTENT_ELEMENT_ID);
    if (bodyNode) {
        bodyNode.focus();

        // Scroll the window in order to ensure that the body is visible.
        setTimeout(function() {
            window.scrollBy(0, document.getElementById(COMPOSE_HEADER_ELEMENT_ID).clientHeight);
        }, 10);
    }
}

/**
 * Expands the summary field. Usually used after the activity is being restored from a configuration change such as device rotation.
 * @param setFocusFieldId an optional string parameter specifying the ID of the CC/BCC field onto which focus will be set after expanding the summary
 */
function expandSummaryField(setFocusFieldId) {
    setTimeout(ccBccFromSummaryFieldController.expandSummaryIntoDetailView.bind(ccBccFromSummaryFieldController, setFocusFieldId), 1);
}

/**
 * Adds an attachment to the attachments band
 * @param id the internal id of the attachment, which is passed back to the native code whenever the user manipulates any attachment
 * @param name the display name of the attachment
 * @param size the size in bytes of the attachment
 * @param imagePlaceHolder the placeholder image thumbnail url of the attachment. Is usually a local file:/// url.
 * @param imageUri The actual image thumbnail url. Can by a local file:/// or a web url.
 * @param sizeString A string representing the size of the attachment
 */
function addAttachment(id, name, size, imagePlaceHolder, imageUri, sizeString) {
    // This method might be triggered multiple times, and we need to make sure each run completes before the next run is invoked.

    // Previously we were doing this as setTimeout(attachmentsController.addAttachment.bind(attachmentsController, id, name, size, imagePlaceHolder, imageUri, sizeString), 7); is causing image to now show up when you share
    // to unsigned yahoo mail and sign in.. Since we added javascript queue on native side and also we use mDomContentLoaded flag, setTimeout will not be required
    attachmentsController.addAttachment(id, name, size, imagePlaceHolder, imageUri, sizeString);
}

/**
 * Inserts an inline image attachment at the current cursor position
 * @param id the internal id of the attachment, which is passed back to the native code whenever the user manipulates any attachment
 * @param imagePlaceHolder the placeholder image thumbnail url of the attachment. Is usually a local file:/// url.
 * @param imageUri The actual image thumbnail url. Can by a local file:/// or a web url.
 * @param contentId The content id, by which this inline attachment will be identified
 */
function addInlineAttachment(id, imagePlaceHolder, imageUri, contentId) {
    // This method might be triggered multiple times, and we need to make sure each run completes before the next run is invoked.

    // Previously we were doing this as setTimeout(attachmentsController.addInlineAttachment.bind(attachmentsController, id, imagePlaceHolder, imageUri, contentId), 7); is causing image to now show up when you share
    // to unsigned yahoo mail and sign in. Since we added javascript queue on native side and also we use mDomContentLoaded flag, setTimeout will not be required
    attachmentsController.addInlineAttachment(id, imagePlaceHolder, imageUri, contentId);
}

/**
 * Delete the attachment with the given id
 * @param id the id of the attachment to be deleted
 */
function deleteAttachment(id) {
    attachmentsController.removeAttachment(id);
}

/**
 * Insert a Cloud Attachment Card
 *
 * @params {string} url
 * @params {string} thumbnailURL
 * @params {string} title
 * @params {string} subtitle
 */
function addCloudAttachment(url, thumbnailURL, title, subtitle) {
    attachmentsController.addCloudAttachment(url, thumbnailURL, title, subtitle);
}

/**
 * Insert a new Gif Card.
 *
 * @param {string} gifUrl - source url for the gif image
 * @param {string} authorName - author's name used for attribution
 * @param {string} authorPageUrl - author's webpage used for attribution
 * @param {string} platformLogoSrcUrl - source url for the platform (example: Tumblr), used for attribution
 * @param {boolean} appendAttribution - true if we want to appendAttribution
 */
function addGifCard(gifUrl, authorName, authorPageUrl, platformLogoSrcUrl, appendAttribution, isTenorGif) {
    attachmentsController.addGifCard(gifUrl, authorName, authorPageUrl, platformLogoSrcUrl, appendAttribution, isTenorGif);
}

/**
 * Adds a lozenge with the given parameters
 * @param id the id of the lozenge to be added
 * @param name the name to be shown on the lozenge
 * @param image the profile image for this contact
 * @param defaultImage the default image for this contact. Usually is an alphatar
 * @param shouldCollapse a boolean indicating whether the lozenges field should collapse after adding the given lozenge
 * @param uniqueTag the unique tag identifying a particular lozengeController
 */
function addContactLozenge(id, name, image, defaultImage, shouldCollapse, uniqueTag) {
    lozengeController.addLozenge(id, name, image, defaultImage, shouldCollapse, uniqueTag);
}

/**
 * Sets the text color of the lozenge
 * @param color the color to be set
 * @param id the id of the lozenge
 */
function setToAddressColorWithAlertIcon(color, id, uniqueTag) {
    lozengeController.setTextColorWithAlertIcon(color, id, uniqueTag);
}

/**
 * Adds an invalid lozenge with the given parameters
 * @param id the id of the lozenge to be added
 * @param name the name to be shown on the lozenge
 * @param uniqueTag the unique tag identifying a particular lozengeController
 */
function addInvalidLozenge(id, name, uniqueTag) {
    lozengeController.addInvalidLozenge(id, name, uniqueTag);
}

/**
 * Removes a lozenge with the given id
 * @param id the id of the lozenge to be removed
 * @param uniqueTag the unique tag identifying a particular lozengeController
 */
function removeContactLozenge(id, uniqueTag) {
    var last = lozengeController.removeLozenge(id, uniqueTag);
    if (last) {
        contactRelatedController.close("");
    }
}

/**
 * Clears the focused state of the lozenge with the given id
 * @param id the id of the lozenge whose focused state needs to be cleared
 * @param uniqueTag the unique tag identifying a particular lozengeController
 */
function clearLozengeFocusState(id, uniqueTag) {
    lozengeController.clearLozengeFocusState(id, uniqueTag);
}

/**
 * Sets the focused state of the lozenge with the given id
 * @param id the id of the lozenge whose focused state needs to be set
 * @param uniqueTag the unique tag identifying a particular lozengeController
 */
function setLozengeFocusState(id, uniqueTag) {
    lozengeController.setLozengeFocusState(id, uniqueTag);
}

/**
 * Sets the typed text in the given recipient field
 *
 * @param text the text to be set
 * @param uniqueTag the unique tag identifying a particular lozengeController
 */
function setTypedText(text, uniqueTag) {
    lozengeController.setTypedText(text, uniqueTag);
}

/**
 * Shows the contact search results for the given recipient field. The results are given in form of a JSON Array.
 * @param resultsJsonArray a JSON Array which encapsulates the results to be shown
 * @param uniqueTag the unique tag identifying a particular contactSearchController
 * @param perfEvent name for performance measurements. Either online (for xobni contacts) or offline (for device contacts).
 * @param permissionPromptSuggestedObject a JSON Object for contact permission prompt
 */
function showContactSearchResults(resultsJsonArray, uniqueTag, perfEvent, header, permissionPromptSuggestedObject) {
    // Expand lozenges for corresponding recipient field for properly adjusting margin top of contactSearchSuggestionsContainer
    lozengeController.expandLozenges(uniqueTag);
    setTimeout(contactSearchController.showResults.bind(contactSearchController, resultsJsonArray, uniqueTag, perfEvent, permissionPromptSuggestedObject), 10);
}

var showResultsTimer = null;

function showContactRelatedResults(resultsJsonArray, uniqueTag, perfEvent, header) {
    lozengeController.expandLozenges(uniqueTag);
    if (showResultsTimer != null) {
        clearTimeout(showResultsTimer);
    }
    showResultsTimer = setTimeout(contactRelatedController.showResults.bind(contactRelatedController, resultsJsonArray, uniqueTag, perfEvent, header), 300);
}

/**
 * Clears all the contents of the recipient field and destroys any search suggestions being shown
 * @param uniqueTag the unique tag identifying a particular contactSearchController
 */
function clearRecipientField(uniqueTag) {
    lozengeController.setTypedText("", uniqueTag);
    destroySearchMode(uniqueTag);
}

/**
 * Destroys any search suggestions being shown, but doesn't clear the recipient field
 * @param uniqueTag the unique tag identifying a particular contactSearchController
 */
function destroySearchMode(uniqueTag) {
    contactSearchController.destroySearchMode(uniqueTag);
}

/**
 * Confirms the user choice of deleting the clicked image
 * @param imageId the image id passed by JavaScript of the image to be deleted.
 * @param isInline a boolean indicating if the image to be deleted is an inline attachment or not
 */
function confirmImageDelete(imageId, isInline) {
    imageTapDeleteController.confirmDelete(imageId, isInline);
}

function moveLinkPreviewToInline(cardId) {
    LinkEnhancr.moveLinkPreviewToInline(cardId);
}

function moveLinkPreviewToBottom(cardId) {
    LinkEnhancr.moveLinkPreviewToBottom(cardId);
}

function removeLinkPreview(cardId) {
    LinkEnhancr.removeLinkPreview(cardId);
}

function handleLinkEnhancrResponse(jsonObj, anchorId) {
    LinkEnhancr.handleLinkEnhancrResponse(jsonObj, anchorId);
}

/**
 * Get the message body contents and call the Java callback with the content
 */
function asyncSaveContent() {
    var composeContentEl = document.getElementById(COMPOSE_CONTENT_ELEMENT_ID);

    // Query all button that used in android only and remove them. We don't want to save these.
    // For link enhancr, we add more button. For GIF/CLOUD, we add remove button.
    var cardButtons = composeContentEl.querySelectorAll("button[class*=" + CLASS_LINK_ENHANCR_MORE_BUTTON + "]," +
            "button[class*=" + REMOVE_BTN_CLASS_NAME + "]");
    if (cardButtons) {
        utils.forEach(cardButtons, function(cardButton){
            cardButton.remove();
        });
    }
    saveBodyBridge.asyncSaveContentCallback(composeContentEl.innerHTML);
}
