(function(yMailBridge, log) {
    'use strict';

    /**
     * Loads Localization Strings Immediately
     */

    var stringsRawJson = yMailBridge.getStrings(),
        strings;

    log.d('[loadStrings] Localization Strings Retrieved: ', stringsRawJson);

    try {
        strings = JSON.parse(stringsRawJson);
    } catch(err) {
        log.e('[loadStrings] Failed Parsing JSON:', err);
    }

    window.strings = strings;
})(window.yMailBridge, window.log);
