/*
 * Copyright (C) 2015 Yahoo Inc.
 */

/**
 * A placeholder id prefix which is attached to every image node which doesn't have an id.
 */
var IMAGE_TAP_CONTROLLER_PLACEHOLDER_ID_PREFIX = "ymail_image_tap_delete_controller_";

/**
 * An object which handles clicks on images and throws a confirmation dialog asking the user if he wants to delete it or not.
 */
var imageTapDeleteController = {
    composeContentNode: null,

    /**
     * A method which starts the imageTapDeleteController
     */
    init: function(composeContentNode) {
        this.composeContentNode = composeContentNode;
        this.composeContentNode.addEventListener('click', this.handleComposeContentClick.bind(this), false);
    },

    /**
     * Handles clicks on the compose content.
     * If the click originated from an image node, invokes Java to throw a delete confirmation prompt to the user.
     */
    handleComposeContentClick: function(event) {
        var imageNode,
            stationeryEditEl = document.querySelector('.rte-stationery-core #middleBody'),
            linkBottomPreviewContainer = document.querySelector("[class*='" + CLASS_LINK_ENHANCR_PREVIEWS + "']");

        if (event.srcElement) {
            if (event.srcElement.tagName && event.srcElement.tagName.indexOf("IMG") >= 0) {
                imageNode = event.srcElement;
            // If it is a img container, find the img inside the container
            } else if (event.srcElement.className && event.srcElement.className.indexOf(INLINED_ATTACHMENT_CONTAINER_CLASS_NAME) >= 0) {
                imageNode = event.srcElement.querySelector('img');
            }
        }

        if (imageNode) {
            if (!imageNode.hasAttribute("id")) {
                imageNode.setAttribute("id", IMAGE_TAP_CONTROLLER_PLACEHOLDER_ID_PREFIX + Math.random());
                syncComposeContent(this.composeContentNode, false);
            }

            // Don't show delete image option for stationery assets and for preview link images
            if ((Stationery.containsStationery() && stationeryEditEl && !utils.isDescendant(stationeryEditEl, imageNode)) || (linkBottomPreviewContainer && utils.isDescendant(linkBottomPreviewContainer, imageNode))) {
                return;
            } else {
                yMailBridge.showImageOptions(imageNode.id, imageNode.id.replace(ATTACHMENT_ID_PREFIX, ""), imageNode.src);
            }
        }
    },

    /**
     * Called back by Java to confirm that the user chose to delete the image
     */
    confirmDelete: function(imageNodeId) {
        var imageNode = document.getElementById(imageNodeId),
            cardContainer;

        if (imageNode) {
            cardContainer = ImageViewController.prototype.getCardContainer(imageNode);
            // Remove the image container if container exists and it is not a single img tag
            if (cardContainer) {
                cardContainer.remove();
            } else if (imageNode.parentNode.className && imageNode.parentNode.className.indexOf(INLINED_ATTACHMENT_CONTAINER_CLASS_NAME) >= 0) {
                imageNode.parentNode.remove();
            } else {
                imageNode.remove();
            }

            syncComposeContent(this.composeContentNode, true);

            // Make sure the focus is on the compose content
            setTimeout(function() { this.composeContentNode.focus(); }.bind(this), 3);
        }
    }
};
