/*
 * Copyright (C) 2014 Yahoo Inc.
 */

// The number of children present when there are no lozenges or data in the address field
var EMPTY_ADDRESS_FIELD_COUNT = 2;

/**
 * An object which controls the show/hide behavior of empty CC/BCC and From fields
 */
var ccBccFromSummaryFieldController = {
    summaryNode: null,
    summaryTextNode: null,
    headerNode: null,
    ccRowNode: null,
    ccInputNode: null,
    bccInputNode: null,
    bccRowNode: null,
    fromNode: null,
    fromAddressTextNode: null,
    ccLozengeContainerNode: null,
    bccLozengeContainerNode: null,
    ccInputNodeId: null,
    bccInputNodeId: null,

    /**
     * A method which starts the ccBccFromSummaryFieldController
     */
    init: function(summaryNode, summaryTextNode, headerNode, ccRowNode, ccInputNode, bccInputNode, bccRowNode, fromNode, fromAddressTextNode, ccLozengeContainerNode, bccLozengeContainerNode, ccInputNodeId, bccInputNodeId) {
        this.summaryNode = summaryNode;
        this.summaryTextNode = summaryTextNode;
        this.headerNode = headerNode;
        this.ccRowNode = ccRowNode;
        this.ccInputNode = ccInputNode;
        this.bccInputNode = bccInputNode;
        this.bccRowNode = bccRowNode;
        this.fromNode = fromNode;
        this.fromAddressTextNode = fromAddressTextNode;
        this.ccLozengeContainerNode = ccLozengeContainerNode;
        this.bccLozengeContainerNode = bccLozengeContainerNode;
        this.ccInputNodeId = ccInputNodeId;
        this.bccInputNodeId = bccInputNodeId;

        // FIXME potential for memory leaks if init is called more than once.
        this.summaryNode.addEventListener('click', this.expandSummaryIntoDetailView.bind(this, ccInputNodeId));
        this.headerNode.addEventListener('focus', this.headerFocusHandler.bind(this), true);
    },

    /**
     * Sets the From address text. Also recomputes the summary text by fetching it from the native code
     */
    setFromAddress: function(address) {
        this.fromAddressTextNode.textContent = address;
        this.summaryTextNode.textContent = yMailBridge.getCCBCCFromRecipientSummaryText();
    },

    /**
     * Expands the summary node into individual CC/BCC/From fields
     * @param setFocusFieldId an optional string parameter specifying the ID of the CC/BCC field onto which focus will be set after expanding the summary
     */
    expandSummaryIntoDetailView: function(setFocusFieldId) {
        if (!contactSearchController.isSearchModeOn) {
            this.summaryNode.classList.add("hidden");

            this.ccRowNode.classList.remove("hidden");

            if (setFocusFieldId) {
                if (this.ccInputNode.id === setFocusFieldId) {
                    this.ccInputNode.parentNode.classList.remove("hidden");
                    this.ccInputNode.focus();
                } else if (this.bccInputNode.id === setFocusFieldId) {
                    this.bccInputNode.parentNode.classList.remove("hidden");
                    this.bccInputNode.focus();
                }
            }

            this.bccRowNode.classList.remove("hidden");
            this.fromNode.classList.remove("hidden");
            yMailBridge.setCCBCCFromRecipientSummaryFieldExpandState(true);
        }
    },

    /**
     * Collapses the detail view into a summary view
     */
    collapseDetailIntoSummaryView: function() {
        if (this.ccLozengeContainerNode.childElementCount === EMPTY_ADDRESS_FIELD_COUNT && this.bccLozengeContainerNode.childElementCount === EMPTY_ADDRESS_FIELD_COUNT && !contactSearchController.isSearchModeOn &&
                !this.ccInputNode.value && !this.bccInputNode.value) {
            this.ccRowNode.classList.add("hidden");
            this.bccRowNode.classList.add("hidden");
            this.fromNode.classList.add("hidden");

            this.summaryNode.classList.remove("hidden");
            yMailBridge.setCCBCCFromRecipientSummaryFieldExpandState(false);
        }
    },

    /**
     * Computes the state of the summary field everytime the focus switched between various fields in the compose view
     */
    headerFocusHandler: function(event) {
        if (event.target.id !== this.ccInputNodeId && event.target.id !== this.bccInputNodeId) {
            // For some version of webview, the focus event will happen first and then the click event will go through.
            // In this case, if we collapse the cc/bcc here, the click event will be triggered at the message body container.
            // Then it will focus the message body afterwards.
            // This is a work around. We collapse the cc/bcc after current event handling cycle.
            setTimeout(this.collapseDetailIntoSummaryView.bind(this), 0);
        }
    }
};
