(function(utils) {
    'use strict';

    /*
     * TODO investigate dynamically setting the save delay value based on time taken to do DOM serialization
     *  This will allow persisting less complex message bodies more often, and more complex message bodies less often.
     */
    var AUTO_SAVE_DELAY_MS = 300,
        debouncingHandleInput;

    /**
     * An object which controls the auto save logic
     */
    window.autoSaveController = {
        composeContentNode: null,

        /**
         * A method which starts the autoSaveController
         */
        init: function(composeContentNode) {
            this.composeContentNode = composeContentNode;
            this.composeContentNode.addEventListener("input", this.handleInput.bind(this), false);
        },

        /**
         * A method which handles input events on the compose content and saves the content back to native Java code
         */
        handleInput: function() {
            if (!debouncingHandleInput) {
                debouncingHandleInput = utils.debounce(window.syncComposeContent.bind(null, this.composeContentNode, false), AUTO_SAVE_DELAY_MS);
            }

            debouncingHandleInput();
        }
    };
})(window.utils);
