(function(CardViewController, strings) {
    'use strict';

    /**
     * External Cloud Attachment Card
     * (Dropbox, Google Drive, etc.)
     */
    function CloudCardViewController() {
        CardViewController.call(this);
    }

    CloudCardViewController.prototype = Object.create(CardViewController.prototype);
    CloudCardViewController.prototype.constructor = CardViewController;

    /**
     * @override
     *
     * @param {string} [properties.url] - url user will be taken to when clicking the card
     * @param {string} [properties.thumbnailURL] - url for the thumbnail image
     * @param {string} [properties.title] - title to display for the card
     * @param {string} [properties.subtitle] - subtitle to display for the card
     */
    CloudCardViewController.prototype.render = function(properties) {
        var containerAnchorEl,
            removeBtnEl,
            mainContentEl,
            titleId = 'cloud-card-title-id-' + this.id;

        properties = properties || {};

        // Anchor element allowing the entire card to be clickable
        containerAnchorEl = document.createElement('a');
        containerAnchorEl.setAttribute('href', properties.url || '');
        containerAnchorEl.setAttribute('rel', 'no follow');
        containerAnchorEl.setAttribute('target', '_blank');
        containerAnchorEl.setAttribute('contenteditable', 'false');
        containerAnchorEl.setAttribute('aria-labelledby', titleId);
        containerAnchorEl.classList.add(CARD_EL_CLASS_NAME);
        containerAnchorEl.classList.add(UNIFIED_CARD_EL_CLASS_NAME);
        containerAnchorEl.setAttribute('style', [
            'display: inline-block',
            'position: relative',
            'max-width: 400px',
            'color: #000',
            'text-decoration: none',
            'background-color: #fff',
            'border: 1px solid #e0e4e9',
            'border-bottom: 3px solid #007ee4',
            'height: 80px'
        ].join('; '));

        // Remove Button
        removeBtnEl = document.createElement('button');
        removeBtnEl.classList.add(REMOVE_BTN_CLASS_NAME);
        removeBtnEl.setAttribute('aria-label', strings.mailskd_accessibility_remove_attachment);
        removeBtnEl.setAttribute('style', [
            'display: none',
            'position: absolute',
            'height: 0',
            'width: 0',
            'border: none',
            'background: none',
            'color: transparent'
        ].join('; '));

        // Main Content Element containing the thumbnail, title, and subtitle
        mainContentEl = document.createElement('div');
        mainContentEl.setAttribute('style', [
            'display: table',
            'table-layout: fixed',
            'width: 100%',
            'height: 80px',
            'text-decoration: none',
            'color: #000',
            'vertical-align: middle'
        ].join('; '));
        mainContentEl.innerHTML =
            '<div style="display: table-cell; width: 32px; padding: 16px 0px 16px 16px; vertical-align: middle;">' +
                '<img style="border: none; margin-top: 3px; max-width:32px;" height="32px" src="' + (properties.thumbnailURL || '') + '"></div>' +
            '<div style="display: table-cell; padding: 16px 20px 16px 20px; vertical-align: middle;">' +
                '<h2 id="' + titleId + '" style="margin: 0 12px 4px 0; font-size: 16px; font-family: Helvetica Neue, Helvetica, Arial, sans-serif; white-space: nowrap; overflow: hidden;">' + (properties.title || '') + '</h2>' +
                '<h2 style="font-size: 11px; font-family: Helvetica Neue, Helvetica, Arial, sans-serif; line-height: 15px; color: #999;margin: 0; white-space: nowrap; overflow: hidden;">' + (properties.subtitle || '') + '</h2>' +
            '</div>';

        containerAnchorEl.appendChild(removeBtnEl);
        containerAnchorEl.appendChild(mainContentEl);

        this.attach(containerAnchorEl, removeBtnEl);

        return containerAnchorEl;
    };

    window.CloudCardViewController = CloudCardViewController;
})(window.CardViewController, window.strings);
