(function(_utils){
    'use strict';

    document.addEventListener('DOMContentLoaded', function() {
        window.addEventListener('resize', resizeWithDebounce);
        resize();
        window.JavascriptDocumentEventHandler.handleDOMContentLoaded();
    });

    var resizeWithDebounce;
    function resize() {
        var minTargetWidth = window.document.body.clientWidth
        if (minTargetWidth != 0 && window.innerWidth >= minTargetWidth) {
            DocumentPreviewJSInterface.onSizeChanged(document.getElementById('container').clientWidth, document.getElementById('container').clientHeight, false);
        }
    }

    resizeWithDebounce = _utils.debounce(resize, 100, false);
})(window.utils);
