/* global ConversationInterface */

(function() {
    'use strict';

    window.formController = {
        prefill: function(name, email) {
            var inputSubmit = document.querySelector('input[type=submit]'),
                inputName = document.querySelector('input[name=fullname]'),
                inputEmail = document.querySelector('input[name=email]');

            if (inputSubmit) {
                if (inputName && name) {
                    inputName.value = name;
                }

                if (inputEmail && email) {
                    inputEmail.value = email;
                }
            }
        },

        bindFormHandler: function(urlTag, methodTag, paramListTag, paramKeyTag, paramValueTag) {
            var forms = document.querySelectorAll('form'),
                form,
                i,
                _onSubmitHandler = function(e) {
                    var currentTarget = e.currentTarget,
                        paramsJson = {},
                        params = [],
                        outputJson = "";

                    if (currentTarget.action) {
                        paramsJson = window.utils.getFormParams(currentTarget, paramKeyTag, paramValueTag);

                        try {
                            outputJson = JSON.stringify(paramsJson);
                        } catch (ex) {
                            window.log.e("Unable to create JSON:" + ex);
                        }

                        window.ConversationInterface.showSubmitContentConfirmation(currentTarget.action, currentTarget.method, outputJson);
                    }

                    return false;
                };

            for (i = 0; i < forms.length; i++) {
                form = forms[i];
                // For form element, take the all input as key/values pairs in json string and pass to native
                form.onsubmit = _onSubmitHandler;
            }
        },


    };
})();